% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport_plan.R
\name{sinkhorn_pot}
\alias{sinkhorn_pot}
\title{Return the dual potentials for the Sinkhorn distance}
\usage{
sinkhorn_pot(
  mass_x,
  mass_y,
  p = 2,
  cost = NULL,
  cost_a = NULL,
  cost_b = NULL,
  ...
)
}
\arguments{
\item{mass_x}{The empirical distribution of the first sample}

\item{mass_y}{The empirical distribution of the second sample}

\item{p}{The power to raise the cost by}

\item{cost}{The cost matrix between first and second samples}

\item{cost_a}{The cost matrix for the first sample}

\item{cost_b}{The cost matrix for the second sample}

\item{...}{Additional arguments including
\itemize{
\item epsilon: The fraction of the median cost to use as a penalty
\item niter: Number of iterations to run the Sinkhorn algorithm
\item unbiased: Should the potentials be de-biased TRUE/FALSE
}}
}
\value{
A list with slots "f" and "g", the potentals of the rows and margins, respectively.
}
\description{
Return the dual potentials for the Sinkhorn distance
}
\keyword{internal}
