% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_duplications.R
\name{imputate_duplications}
\alias{imputate_duplications}
\title{Impute duplication events based on a vector of species}
\usage{
imputate_duplications(tree, species)
}
\arguments{
\item{tree}{An object of class \link[ape:read.tree]{ape::phylo}.}

\item{species}{A character vector of length \code{ape::Ntip(tree)} (see details).}
}
\value{
A logical vector of length \code{ape::Nnode(tree, internal.only = FALSE)}
with \code{TRUE} to indicate that the corresponding node is a duplication event.
The order matches that in the input tree.
}
\description{
Uses a simple algorithm to impute duplication events based on the
terminal genes of the tree. An interior node is a duplication event
if a specie has two or more leafs within its clade.
}
\details{
This function will take a vector of species and, based on that, assign
duplication events throughout the interior nodes. An interior node is labeled
as a duplication event if two or more of the leaves within it are from the
same species.
}
\examples{

# Data from PANTHER
path <- system.file("tree.tree", package="aphylo")
ptree <- read_panther(path)

# Extracting the species
sp <- gsub(".+[:]|[|].+", "" , ptree$tree$tip.label)

# Imputing duplications
imputate_duplications(ptree$tree, species = sp)
}
