% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy_sifter.R
\name{accuracy_sifter}
\alias{accuracy_sifter}
\alias{accuracy_sifter.aphylo_estimates}
\alias{accuracy_sifter.default}
\title{Accuracy calculation as defined in Engelhardt et al. (2011)}
\usage{
accuracy_sifter(pred, lab, tol = 1e-10, highlight = "", ...)

\method{accuracy_sifter}{aphylo_estimates}(pred, lab, tol = 1e-10, highlight = "", ...)

\method{accuracy_sifter}{default}(pred, lab, tol = 1e-10, highlight = "", nine_na = TRUE, ...)
}
\arguments{
\item{pred}{A matrix of predictions, or an \link{aphylo_estimates} object.}

\item{lab}{A matrix of labels (0,1,NA, or 9 if \code{nine_na = TRUE}).}

\item{tol}{Numeric scalar. Predictions within \code{tol} of the max score
will be tagged as the prediction made by the model (see deails).}

\item{highlight}{Pattern passed to \link{sprintf} used to highlight
predicted functions that match the observed.}

\item{...}{Further arguments passed to the method. In the case of \code{aphylo_estimates},
the arguments are passed to \code{\link[=predict.aphylo_estimates]{predict.aphylo_estimates()}}.}

\item{nine_na}{Treat 9 as NA.}
}
\value{
A data frame with \code{Ntip()} rows and four variables. The variables are:
\itemize{
\item Gene: Label of the gene
\item Predicted: The assigned gene function.
\item Observed: The true set of gene functions.
\item Accuracy: The measurement of accuracy according to Engelhardt et al. (2011).
}
}
\description{
Uses SIFTER's 2011 definition of accuracy, where a protein is tagged as
accurately predicted if the highest ranked prediction matches it.
}
\details{
The analysis is done at the protein level. For each protein, the function
compares the YES annotations of that proteins with the predicted by the model.
The algorithm selects the predicted annotations as those that are within
\code{tol} of the maximum score.

This algorithm doesn't take into account NOT annotations (0s), which are
excluded from the analysis.

When \code{highlight = ""}, no highlight is done.
}
\examples{
set.seed(81231)
atree <- raphylo(50, psi = c(0,0), P = 3)
ans <- aphylo_mcmc(atree ~ mu_d + mu_s + Pi)

accuracy_sifter(ans)

}
