% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_nodata}
\alias{ax_nodata}
\title{Configuration for charts with no data}
\usage{
ax_nodata(
  ax,
  text = "No data",
  align = "center",
  verticalAlign = "middle",
  color = NULL,
  fontSize = NULL,
  fontFamily = NULL,
  offsetX = NULL,
  offsetY = NULL
)
}
\arguments{
\item{ax}{An \code{apexcharts} \code{htmlwidget} object.}

\item{text}{The text to display when no-data is available.}

\item{align}{Horizontal alignment: \code{"left"}, \code{"center"} or \code{"right"}.}

\item{verticalAlign}{Vertical alignment: \code{"top"}, \code{"middle"} or \code{"bottom"}.}

\item{color}{ForeColor of the text.}

\item{fontSize}{FontSize of the text.}

\item{fontFamily}{FontFamily of the text.}

\item{offsetX, offsetY}{Text offset.}
}
\value{
An \code{apexcharts} \code{htmlwidget} object.
}
\description{
Configuration for charts with no data
}
\examples{
empty <- data.frame(
  var1 = character(0),
  var2 = numeric(0)
)
apex(empty, aes(var1, var2), "column") \%>\% 
  ax_nodata(
    text = "Sorry no data to visualize",
    fontSize = "30px"
  )
}
