% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCongestionLink.R
\name{addCongestionLink}
\alias{addCongestionLink}
\title{Add the congestion frequency and the number of congested hours for a given link}
\usage{
addCongestionLink(x, timeStep = c("daily", "weekly", "monthly", "annual"))
}
\arguments{
\item{x}{Object of class \code{antaresData} created with function
\code{\link[antaresRead]{readAntares}}. It must contain the columns
\code{CONG. PROB +} and \code{CONG. PROB -} and be at an hourly timestep.}

\item{timeStep}{\code{character} Desired time step for the result.}
}
\value{
\code{addCongestionLink} modifies its input by adding four columns:

\item{congestionFrequencyDirect}{

This is the congestion frequency on the direct direction of the link at the specified time resolution.
\preformatted{congestionFrequencyDirect = round(sum((`CONG. PROB +` != 0)/.N), 2)}

}

\item{congestionFrequencyIndirect }{

This is the congestion frequency on the indirect direction of the link at the specified time resolution.
\preformatted{congestionFrequencyIndirect  = round(sum((`CONG. PROB -` != 0)/.N), 2)}

}

\item{congestionHoursDirect}{

This is the number of congestion hours on the direct direction of the link at the specified time resolution.
\preformatted{congestionHoursDirect  = sum(`CONG. PROB +` != 0)}

}

\item{congestionHoursIndirect }{

This is the number of congestion hours on the direct direction of the link at the specified time resolution.
\preformatted{congestionHoursIndirect =  sum(`CONG. PROB -` != 0)}

}
}
\description{
This function computes 4 congestion variables of link (congestion frequency and congestion hours in direct and indirect direction) and adds them to an
\code{antaresData} object. The input object must be at an hourly timestep.
}
\examples{
\dontrun{
# Data required by the function

mydata <- readAntares(links = "all")
mydata <- addCongestionLink(mydata, timeStep = "daily")
names(mydata)

mydata <- addCongestionLink(mydata, timeStep = c('daily'))
}

}
