% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeEconomicOptions.R
\name{writeEconomicOptions}
\alias{writeEconomicOptions}
\title{Write Economic Options}
\usage{
writeEconomicOptions(x, opts = antaresRead::simOptions())
}
\arguments{
\item{x}{A dataframe. Must contain an \code{area} column listing some (but not
necessarily all) areas of the study. Can contain up to 7 other columns among:
\code{average_unsupplied_energy_cost}, \code{spread_unsupplied_energy_cost},
\code{average_spilled_energy_cost}, \code{spread_spilled_energy_cost},
(numeric columns), \code{non_dispatchable_power},
\code{dispatchable_hydro_power} and \code{other_dispatchable_power}
(logical columns).}

\item{opts}{List of simulation parameters returned by the function
\code{antaresRead::setSimulationPath}}
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

This function allows to create or edit economic options. Areas/options present
in the input dataframe are edited, while all other values are left unchanged.
}
\examples{
\dontrun{

library(antaresRead)

# Set simulation path
setSimulationPath(path = "PATH/TO/SIMULATION", simulation = "input")

# Write some economic options for areas a, b and c
writeEconomicOptions(data.frame(
  area = c("a", "b", "c"),
  dispatchable_hydro_power = c(TRUE, FALSE, FALSE),
  spread_unsupplied_energy_cost = c(0.03, 0.024, 0.01),
  average_spilled_energy_cost = c(10, 8, 8),
  stringsAsFactors = FALSE
))

}
}
