% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateAdequacySettings.R
\name{updateAdequacySettings}
\alias{updateAdequacySettings}
\title{Update adequacy parameters of an Antares study}
\usage{
updateAdequacySettings(
  include_adq_patch = NULL,
  set_to_null_ntc_from_physical_out_to_physical_in_for_first_step = NULL,
  set_to_null_ntc_between_physical_out_for_first_step = NULL,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{include_adq_patch}{Logical. If TRUE, will run Adequacy Patch}

\item{set_to_null_ntc_from_physical_out_to_physical_in_for_first_step}{Logical. default to TRUE}

\item{set_to_null_ntc_between_physical_out_for_first_step}{Logical. default to TRUE}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Update adequacy parameters of an Antares study
}
\examples{
\dontrun{

updateAdequacySettings(
  include_adq_patch = TRUE,
  set_to_null_ntc_from_physical_out_to_physical_in_for_first_step = TRUE,
  set_to_null_ntc_between_physical_out_for_first_step = TRUE
)

}

}
