% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hash.R
\name{hash}
\alias{hash}
\title{Hash a vector.}
\usage{
hash(.x, .algo = "sha256", .seed = 0, ...)
}
\arguments{
\item{.x}{a vector.}

\item{.algo}{the name of the algorithm.}

\item{.seed}{an integer to seed the random number generator.}

\item{...}{additional arguments to be based to \code{\link[digest]{digest}}.}
}
\value{
A hashed version of the vector.
}
\description{
See \code{\link[digest]{digest}} for additional documentation.
}
\details{
The user is advised to check out \href{https://en.wikipedia.org/wiki/Hash_function}{Wikipedia} for more information.
}
\examples{
# All algorithms available to digest::digest are available here
set.seed(1)
hash(letters, .algo = "sha256")
hash(letters, .algo = "crc32")
}

