% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horns_curve.R
\name{horns_curve}
\alias{horns_curve}
\title{Horn's Parallel Analysis}
\usage{
horns_curve(data, n, p, nsim = 1000L)
}
\arguments{
\item{data}{A matrix or data frame.}

\item{n}{Integer specifying the number of rows.}

\item{p}{Integer specifying the number of columns.}

\item{nsim}{Integer specifying the number of Monte Carlo simulations to run.
Default is \code{1000}.}
}
\value{
A vector of length \code{p} containing the averaged eigenvalues. The
values can then be plotted or compared to the true eigenvalues from a dataset
for a dimensionality reduction assessment.
}
\description{
Computes the average eigenvalues produced by a Monte Carlo simulation that
randomly generates a large number of \code{n}x\code{p} matrices of standard
normal deviates.
}
\examples{
# Perform Horn's Parallel analysis with matrix n x p dimensions
x <- matrix(rnorm(200 * 10), ncol = 10)
horns_curve(x)
horns_curve(n = 200, p = 10)
plot(horns_curve(x))  # scree plot
}
\references{
J. L. Horn, "A rationale and test for the number of factors in factor
analysis," Psychometrika, vol. 30, no. 2, pp. 179-185, 1965.
}
