% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractBoxes.R
\name{extractBoxes}
\alias{extractBoxes}
\title{Extract bounding boxes for a single image and save as new images}
\usage{
extractBoxes(
  image,
  min_conf = 0,
  buffer = 2,
  plot = TRUE,
  return.crops = FALSE,
  save = FALSE,
  resize = NA,
  outdir = "",
  quality = 0.8
)
}
\arguments{
\item{image}{single image, raw MD output}

\item{min_conf}{Confidence threshold (defaults to 0, not in use)}

\item{buffer}{Adds a buffer to the MD bounding box, defaults to 2px}

\item{plot}{Toggle to plot each crop in the plot window, defaults to TRUE}

\item{return.crops}{Toggle to return list of cropped images, defaults to FALSE}

\item{save}{Toggle to save output cropped, defaults to FALSE}

\item{resize}{Size in pixels to resize cropped images, NA if images are not resized, defaults to NA}

\item{outdir}{Directory in which output cropped images will be saved}

\item{quality}{Compression level of output cropped image, defaults to 0.8}
}
\value{
a flattened dataframe containing crop information
}
\description{
Requires the unflattened raw MD output
}
\examples{
\dontrun{
images<-read_exif(imagedir,tags=c("filename","directory"), recursive = TRUE)
crops <- extractBoxes(images[1,],plot=TRUE,return.crops=TRUE,save=TRUE)
}
}
