% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractBoxes.R
\name{extractAllBoxes}
\alias{extractAllBoxes}
\title{Extract bounding boxes and save as new image from a batch of images}
\usage{
extractAllBoxes(
  images,
  min_conf = 0,
  buffer = 2,
  save = FALSE,
  resize = NA,
  outdir = "",
  quality = 0.8,
  parallel = FALSE,
  nproc = parallel::detectCores()
)
}
\arguments{
\item{images}{list of images, raw MD output}

\item{min_conf}{Confidence threshold (defaults to 0, not in use)}

\item{buffer}{Adds a buffer to the MD bounding box, defaults to 2px}

\item{save}{Toggle to save output cropped, defaults to FALSE}

\item{resize}{Size in pixels to resize cropped images, NA if images are not resized, defaults to NA}

\item{outdir}{Directory in which output cropped images will be saved}

\item{quality}{Compression level of output cropped image, defaults to 0.8}

\item{parallel}{Toggle to enable parallel processing, defaults to FALSE}

\item{nproc}{Number of workers if parallel = TRUE, defaults to output of detectCores()}
}
\value{
a flattened dataframe containing crop information
}
\description{
Extract bounding boxes and save as new image from a batch of images
}
\examples{
\dontrun{
images<-read_exif(imagedir,tags=c("filename","directory"), recursive = TRUE)
crops <- extractAllBoxes(images,save=TRUE,out)
}
}
