% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-.r, R/geom-.r, R/annotation-custom.r,
%   R/annotation-logticks.r, R/geom-polygon.r, R/geom-map.r, R/annotation-map.r,
%   R/geom-raster.r, R/annotation-raster.r, R/coord-.r, R/coord-cartesian-.r,
%   R/coord-fixed.r, R/coord-flip.r, R/coord-map.r, R/coord-polar.r,
%   R/coord-quickmap.R, R/coord-transform.r, R/stat-.r, R/geom-abline.r,
%   R/geom-rect.r, R/geom-bar.r, R/geom-bin2d.r, R/geom-blank.r, R/geom-path.r,
%   R/geom-contour.r, R/geom-crossbar.r, R/geom-segment.r, R/geom-curve.r,
%   R/geom-ribbon.r, R/geom-density.r, R/geom-density2d.r, R/geom-dotplot.r,
%   R/geom-errorbar.r, R/geom-errorbarh.r, R/geom-freqpoly.r, R/geom-hex.r,
%   R/geom-hline.r, R/geom-label.R, R/geom-linerange.r, R/geom-point.r,
%   R/geom-pointrange.r, R/geom-rug.r, R/geom-smooth.r, R/geom-spoke.r,
%   R/geom-text.r, R/geom-tile.r, R/geom-violin.r, R/geom-vline.r,
%   R/position-.r, R/position-dodge.r, R/position-fill.r, R/position-identity.r,
%   R/position-jitter.r, R/position-jitterdodge.R, R/position-nudge.R,
%   R/position-stack.r, R/scale-.r, R/scale-continuous.r, R/scale-date.r,
%   R/scale-discrete-.r, R/scale-identity.r, R/scales-.r, R/stat-bin.r,
%   R/stat-bin2d.r, R/stat-bindot.r, R/stat-binhex.r, R/stat-contour.r,
%   R/stat-count.r, R/stat-density-2d.r, R/stat-density.r, R/stat-ecdf.r,
%   R/stat-ellipse.R, R/stat-function.r, R/stat-identity.r, R/stat-qq.r,
%   R/stat-smooth.r, R/stat-sum.r, R/stat-summary-2d.r, R/stat-summary-bin.R,
%   R/stat-summary-hex.r, R/stat-summary.r, R/stat-unique.r, R/stat-ydensity.r,
%   R/z_geoms.R
\docType{data}
\name{animint2-gganimintproto}
\alias{animint2-gganimintproto}
\alias{Geom}
\alias{GeomCustomAnn}
\alias{GeomLogticks}
\alias{GeomPolygon}
\alias{GeomMap}
\alias{GeomAnnotationMap}
\alias{GeomRaster}
\alias{GeomRasterAnn}
\alias{Coord}
\alias{CoordCartesian}
\alias{CoordFixed}
\alias{CoordFlip}
\alias{CoordMap}
\alias{CoordPolar}
\alias{CoordQuickmap}
\alias{CoordTrans}
\alias{Stat}
\alias{GeomAbline}
\alias{GeomRect}
\alias{GeomBar}
\alias{GeomBin2d}
\alias{GeomBlank}
\alias{GeomPath}
\alias{GeomLine}
\alias{GeomStep}
\alias{GeomContour}
\alias{GeomCrossbar}
\alias{GeomSegment}
\alias{GeomCurve}
\alias{GeomRibbon}
\alias{GeomArea}
\alias{GeomDensity}
\alias{GeomDensity2d}
\alias{GeomDotplot}
\alias{GeomErrorbar}
\alias{GeomErrorbarh}
\alias{GeomFreqpoly}
\alias{GeomHex}
\alias{GeomHline}
\alias{GeomLabel}
\alias{GeomLinerange}
\alias{GeomPoint}
\alias{GeomPointrange}
\alias{GeomRug}
\alias{GeomSmooth}
\alias{GeomSpoke}
\alias{GeomText}
\alias{GeomTile}
\alias{GeomViolin}
\alias{GeomVline}
\alias{Position}
\alias{PositionDodge}
\alias{PositionFill}
\alias{PositionIdentity}
\alias{PositionJitter}
\alias{PositionJitterdodge}
\alias{PositionNudge}
\alias{PositionStack}
\alias{Scale}
\alias{ScaleContinuous}
\alias{ScaleDiscrete}
\alias{ScaleContinuousPosition}
\alias{ScaleContinuousDatetime}
\alias{ScaleContinuousDate}
\alias{ScaleDiscretePosition}
\alias{ScaleDiscreteIdentity}
\alias{ScaleContinuousIdentity}
\alias{a_scales_list}
\alias{ScalesList}
\alias{StatBin}
\alias{StatBin2d}
\alias{StatBindot}
\alias{StatBinhex}
\alias{StatContour}
\alias{StatCount}
\alias{StatDensity2d}
\alias{StatDensity}
\alias{StatEcdf}
\alias{StatEllipse}
\alias{StatFunction}
\alias{StatIdentity}
\alias{StatQq}
\alias{StatSmooth}
\alias{StatSum}
\alias{StatSummary2d}
\alias{StatSummaryBin}
\alias{StatSummaryHex}
\alias{StatSummary}
\alias{StatUnique}
\alias{StatYdensity}
\alias{GeomTallRect}
\alias{GeomWideRect}
\title{Base gganimintproto classes for ggplot2}
\format{
An object of class \code{ScalesList} (inherits from \code{gganimintproto}) of length 9.
}
\usage{
a_scales_list()

ScalesList
}
\description{
If you are creating a new geom, stat, position, or scale in another package,
you'll need to extend from \code{animint2::Geom}, \code{animint2::Stat},
\code{animint2::Position}, or \code{animint2::Scale}.
}
\section{Geoms}{


All \code{geom_*} functions (like \code{geom_point}) return a layer that
contains a \code{Geom*} object (like \code{GeomPoint}). The \code{Geom*}
object is responsible for rendering the data in the plot.

Each of the \code{Geom*} objects is a \code{\link{gganimintproto}} object, descended
from the top-level \code{Geom}, and each implements various methods and
fields. To create a new type of Geom object, you typically will want to
implement one or more of the following:

Compared to \code{Stat} and \code{Position}, \code{Geom} is a little
different because the execution of the setup and compute functions is
split up. \code{setup_data} runs before position adjustments, and
\code{draw_layer} is not run until render time,  much later. This
means there is no \code{setup_params} because it's hard to communicate
the changes.

\itemize{
  \item Override either \code{draw_panel(self, data, panel_scales, coord)} or
    \code{draw_group(self, data, panel_scales, coord)}. \code{draw_panel} is
    called once per panel, \code{draw_group} is called once per group.

    Use \code{draw_panel} if each row in the data represents a
    single element. Use \code{draw_group} if each group represents
    an element (e.g. a smooth, a violin).

    \code{data} is a data frame of scaled aesthetics. \code{panel_scales}
    is a list containing information about the scales in the current
    panel. \code{coord} is a coordinate specification. You'll
    need to call \code{coord$transform(data, panel_scales)} to work
    with non-Cartesian coords. To work with non-linear coordinate systems,
    you typically need to convert into a primitive geom (e.g. point, path
    or polygon), and then pass on to the corresponding draw method
    for munching.

    Must return a grob. Use \code{\link{zeroGrob}} if there's nothing to
    draw.
  \item \code{draw_key}: Renders a single legend key.
  \item \code{required_aes}: A character vector of aesthetics needed to
    render the geom.
  \item \code{default_aes}: A list (generated by \code{\link{aes}()} of
    default values for aesthetics.
  \item \code{reparameterise}: Converts width and height to xmin and xmax,
    and ymin and ymax values. It can potentially set other values as well.
}
}

\section{Coordinate systems}{


All \code{coord_*} functions (like \code{coord_trans}) return a \code{Coord*}
object (like \code{CoordTrans}). The \code{Coord*} object is responsible for
adjusting the position of overlapping geoms.

The way that the \code{coord_*} functions work is slightly different from the
\code{geom_*} and \code{stat_*} functions, because a \code{coord_*} function
actually "instantiates" the \code{Coord*} object by creating a descendant,
and returns that.

Each of the \code{Coord*} objects is a \code{\link{gganimintproto}} object,
descended from the top-level \code{Coord}.  To create a new type of Coord
object, you typically will want to implement one or more of the following:

\itemize{
  \item \code{aspect}: Returns the desired aspect ratio for the plot.
  \item \code{labels}: Returns a list containing labels for x and y.
  \item \code{render_fg}: Renders foreground elements.
  \item \code{render_bg}: Renders background elements.
  \item \code{render_axis_h}: Renders the horizontal axis.
  \item \code{render_axis_v}: Renders the vertical axis.
  \item \code{range}: Returns the x and y ranges
  \item \code{train}: Return the trained scale ranges.
  \item \code{transform}: Transforms x and y coordinates.
  \item \code{distance}: Calculates distance.
  \item \code{is_linear}: Returns \code{TRUE} if the coordinate system is
    linear; \code{FALSE} otherwise.
}
}

\section{Stats}{


All \code{stat_*} functions (like \code{stat_bin}) return a layer that
contains a \code{Stat*} object (like \code{StatBin}). The \code{Stat*}
object is responsible for rendering the data in the plot.

Each of the \code{Stat*} objects is a \code{\link{gganimintproto}} object, descended
from the top-level \code{Stat}, and each implements various methods and
fields. To create a new type of Stat object, you typically will want to
implement one or more of the following:

\itemize{
  \item Override one of :
    \code{compute_layer(self, data, scales, ...)},
    \code{compute_panel(self, data, scales, ...)}, or
    \code{compute_group(self, data, scales, ...)}.

    \code{compute_layer()} is called once per layer, \code{compute_panel_()}
    is called once per panel, and \code{compute_group()} is called once per
    group. All must return a data frame.

    It's usually best to start by overriding \code{compute_group}: if
    you find substantial performance optimisations, override higher up.
    You'll need to read the source code of the default methods to see
    what else you should be doing.

    \code{data} is a data frame containing the variables named according
    to the aesthetics that they're mapped to. \code{scales} is a list
    containing the \code{x} and \code{y} scales. There functions are called
    before the facets are trained, so they are global scales, not local
    to the individual panels.\code{...} contains the parameters returned by
    \code{setup_params()}.
  \item \code{setup_params(data, params)}: called once for each layer.
     Used to setup defaults that need to complete dataset, and to inform
     the user of important choices. Should return list of parameters.
  \item \code{setup_data(data, params)}: called once for each layer,
     after \code{setp_params()}. Should return modified \code{data}.
     Default methods removes all rows containing a missing value in
     required aesthetics (with a warning if \code{!na.rm}).
  \item \code{required_aes}: A character vector of aesthetics needed to
    render the geom.
  \item \code{default_aes}: A list (generated by \code{\link{aes}()} of
    default values for aesthetics.
}
}

\section{Positions}{


All \code{position_*} functions (like \code{position_dodge}) return a
\code{Position*} object (like \code{PositionDodge}). The \code{Position*}
object is responsible for adjusting the position of overlapping geoms.

The way that the \code{position_*} functions work is slightly different from
the \code{geom_*} and \code{stat_*} functions, because a \code{position_*}
function actually "instantiates" the \code{Position*} object by creating a
descendant, and returns that.

Each of the \code{Position*} objects is a \code{\link{gganimintproto}} object,
descended from the top-level \code{Position}, and each implements the
following methods:

\itemize{
  \item \code{compute_layer(self, data, params, panel)} is called once
    per layer. \code{panel} is currently an internal data structure, so
    this method should not be overriden.

  \item \code{compute_panel(self, data, params, panel)} is called once per
    panel and should return a modified data frame.

    \code{data} is a data frame containing the variables named according
    to the aesthetics that they're mapped to. \code{scales} is a list
    containing the \code{x} and \code{y} scales. There functions are called
    before the facets are trained, so they are global scales, not local
    to the individual panels. \code{params} contains the parameters returned by
    \code{setup_params()}.
  \item \code{setup_params(data, params)}: called once for each layer.
     Used to setup defaults that need to complete dataset, and to inform
     the user of important choices. Should return list of parameters.
  \item \code{setup_data(data, params)}: called once for each layer,
     after \code{setp_params()}. Should return modified \code{data}.
     Default checks that required aesthetics are present.
}

And the following fields
\itemize{
  \item \code{required_aes}: a character vector giving the aesthetics
     that must be present for this position adjustment to work.
}
}

\section{Scales}{


All \code{scale_*} functions (like \code{scale_x_continuous}) return a
\code{Scale*} object (like \code{ScaleContinuous}). The \code{Scale*}
object represents a single scale.

Each of the \code{Scale*} objects is a \code{\link{gganimintproto}} object,
descended from the top-level \code{Scale}.
}

\seealso{
gganimintproto
}
\keyword{datasets}
\keyword{internal}
