% Generated by roxygen2 (4.0.2): do not edit by hand
\name{anim.save}
\alias{anim.save}
\title{Save an anim.frames object in various formats.}
\usage{
anim.save(obj, type, filename, ...)
}
\arguments{
\item{obj}{an \code{anim.frames} object}

\item{type}{one of 'GIF', 'Video', 'SWF', 'HTML', or 'Latex'}

\item{filename}{file to save to}

\item{...}{arguments passed to e.g. \code{\link{saveGIF}}}
}
\description{
This function simply calls replay on the object and then calls
\code{\link{saveGIF}} and friends on the result.
}
\details{
For most of the underlying functions, the \code{times} parameter
will be ignored as if you had set \code{use.times=FALSE}.
}
\examples{
\dontrun{
tmp <- anim.plot(1:10, 1:10, pch=1:10, show=FALSE)
anim.save(tmp, "GIF", "filename.gif")

## for anything more complex. Note the curlies:
saveGIF({replay(tmp, after=legend("topleft", legend="My legend"))},
 "filename.gif")
}
}

