% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MADproject.R
\docType{class}
\name{MADproject-class}
\alias{MADproject-class}
\alias{MADproject}
\title{An S4 class to represent a MAD project}
\description{
An S4 class to represent a MAD project
}
\section{Slots}{

\describe{
\item{\code{madname}}{Character string, the name of the MAD#
project}

\item{\code{resultname}}{Character string, the name of the MAD#
project's result}

\item{\code{xpath}}{Character string, the path where to find the
MAD# project's result}

\item{\code{numLocations}}{A numeric value for the number of
measurement locations}

\item{\code{numTimesteps}}{A numeric value for the number of
time steps in series}

\item{\code{numSamples}}{A numeric value for the number of
samples}

\item{\code{numAnchors}}{A numeric value for the number of
local parameters to be inferred}

\item{\code{numTheta}}{A numeric value for the number of
global parameters to be inferred}

\item{\code{truevalues}}{A numeric vector of length
\code{numAnchors+numTheta} that contains
the true values of the parameters being inferred,
if known (i.e. for validation)}

\item{\code{observations}}{A numeric vector containing the
observed values of inversion data}

\item{\code{realizations}}{A data.frame containing the the
ensemble of simulated inversion data
for each sample}

\item{\code{priors}}{A data.frame containing the values sampled
from the priors for each parameter to be inferred plus
estimated marginal density}

\item{\code{likelihoods}}{A data.frame of likelihood values
calculated for each sample}

\item{\code{posteriors}}{A data.frame containing the posterior
values estimated for each sample of each parameter}
}}

