% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceData.R
\docType{methods}
\name{reduceData}
\alias{reduceData}
\alias{reduceData,MADproject,function,ANY-method}
\alias{reduceData,MADproject,function,function-method}
\title{Apply the requested dimension reduction technique to the
inversion data for the given \code{MADproject} object}
\usage{
reduceData(proj, method, params, ...)

\S4method{reduceData}{MADproject,`function`,ANY}(proj, method)

\S4method{reduceData}{MADproject,`function`,`function`}(proj, method, params,
  ...)
}
\arguments{
\item{proj}{\code{MADproject} object that has been filled by
MAD# databases}

\item{method}{function to apply to data}

\item{params}{function for estimating the initial values of
the parameters of \code{method} based on the data, if
\code{method} has parameters}

\item{...}{addtional arguments as needed for \code{nls} to
fit \code{method} to the data}
}
\value{
proj \code{MADproject} object with reduced dimensions
for inversion
}
\description{
\code{reduceData} returns a modifed \code{MADproject}
object where the \code{observations} and \code{realizations}
slots are replaced by a lower-dimensional representation
}
\section{Methods (by class)}{
\itemize{
\item \code{proj = MADproject,method = function,params = ANY}: Fit \code{method} without any parameters (e.g, \code{min})

\item \code{proj = MADproject,method = function,params = function}: Fit \code{method} with parameters and inital guesses for the parameter values
}}

\examples{
data(pumping)
pumping.min <- reduceData(pumping, min)
plotMAD(pumping.min, "realizations")

}
