% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tgsbootV1.R
\name{tgsboot}
\alias{tgsboot}
\title{Bootstrap for Stationary Data}
\usage{
tgsboot(tseries, nb = 1, b.info = FALSE)
}
\arguments{
\item{tseries}{a numeric vector or time series giving the original data.}

\item{nb}{the number of bootstrap series to compute.}

\item{b.info}{if TRUE, the value of the \code{b} parameter found is returned as well.
The default is FALSE.}
}
\value{
If b.info is FALSE, a matrix or time series with nb columns and length(tseries) rows
containing the bootstrap data. Each column contains one bootstrap sample.
If b.info is TRUE, a list with two fields: one containing the bootstrap data, and
another containing the \code{b} value found.
}
\description{
Generate bootstrap samples for stationary data, using a
truncated geometric distribution to more accurately determine the value of the
\code{p} parameter involved in the algorithm.
}
\details{
The value of the \code{b} parameter involved in the stationary bootstrap
algorithm is determined using the heuristic laid out in Politis & White (2004).
Then, the value of the \code{p} parameter is found by numerically solving a
polynomial of order N+1 in variable \code{q}, where \eqn{q = 1-p} and N is the
length of the data supplied.
The previous polynomial is derived using the expectation of a truncated geometric
distribution (for the stochastic block length), shown in Olatayo (2014).

The general structure of the algorithm is similar to the one laid out in James & Yang (2010).
}
\examples{
set.seed(123)
x = rnorm(1e4)
boot = tgsboot(x)
boot = tgsboot(x, b.info = TRUE)
boot = tgsboot(x, nb = 2)
boot = tgsboot(x, nb = 2, b.info = TRUE)

}
\references{
Politis, D.N. and Romano, J.P. (1994), 'The stationary bootstrap', Journal of the
American Statistical Association 89(428), 1303-1313.

Politis, D.N. and White, H. (2004), 'Automatic block-length selection for the
dependent bootstrap', Econometric Reviews 23(1), 53-70.

Olatayo, T.O. (2014), 'Truncated geometric bootstrap method for timeseries
stationary process', Applied Mathematics 5, 2057-2061.

James, J. and Yang, L. (2010), 'Stop-losses, maximum drawdown-at-risk and
replicating financial time series with the stationary bootstrap',
Quantitative Finance 10(1), 1-12.
}
\author{
Albert Dorador
}
