% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R
\name{loadPipeline}
\alias{loadPipeline}
\title{Loads the \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object from the file system}
\usage{
loadPipeline(path, input = data.frame(), filePath = "")
}
\arguments{
\item{path}{the path at which the .Rds file containing the pipeline is located}

\item{input}{(optional) data frame with which the pipeline object should be initialized}

\item{filePath}{(optional) path where a dataset in .CSV format is present which is to be loaded}
}
\value{
An \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object, optinally initialized with the data frame provided
}
\description{
Loads the \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object from the file system
}
\details{
The \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object is loaded into the file system from the file system
      based on the path specified.

Optionally, the \code{input} parameter can be provided to
      initialize the \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object with an R data frame
      or Streaming Spark DataFrame (in case of \code{StreamingAnalysisPipeline} object) present in the R session.

Another provided option, is to specify a filePath where the input dataset is present (in a .CSV format)
      and the object will be initialized with this data frame. The \code{filePath} parameter takes precedence over
      \code{input} parameter. This is applicable only from \code{AnalysisPipeline} objects

Note - When a pipeline is loaded, the existing registry is overwritten with the registry saved with the
pipeline
}
\examples{
\dontrun{
  library(analysisPipelines)
  loadPipeline(path = "./pipeline.RDS")
}
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
