% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R, R/core-functions-batch.R
\docType{methods}
\name{checkSchemaMatch}
\alias{checkSchemaMatch}
\alias{checkSchemaMatch,AnalysisPipeline-method}
\title{Checks the schema of the input to a Pipeline object against the original}
\usage{
checkSchemaMatch(object, newData)

\S4method{checkSchemaMatch}{AnalysisPipeline}(object, newData)
}
\arguments{
\item{object}{A Pipeline object}

\item{newData}{The newData that the pipeline is to be initialized with}
}
\value{
Returns a list with details on added columns, removed columns, comparison between column classes, and a logical
        whether the schema has remained the same from the old dataframe to the new one
}
\description{
Checks the schema of the input to a Pipeline object against the original
}
\details{
Checks the schema of the new data frame that the pipeline is to be initialized with against
         the original schema that the pipeline was saved with. Provides a detailed comparison
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
