% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr_overlap.R
\name{hr_overlaps}
\alias{hr_overlaps}
\alias{hr_overlap}
\alias{hr_overlap.hr}
\alias{hr_overlap.list}
\title{Methods to calculate home-range overlaps}
\usage{
hr_overlap(x, ...)

\method{hr_overlap}{hr}(x, y, type = "hr", conditional = FALSE, ...)

\method{hr_overlap}{list}(
  x,
  type = "hr",
  conditional = FALSE,
  which = "consecutive",
  labels = NULL,
  ...
)
}
\arguments{
\item{x, y}{A home-range estimate}

\item{...}{Further arguments, none implemented.}

\item{type}{\verb{[character](1)} \cr Type of index, should be one of \code{hr}, \code{phr},
\code{vi}, \code{ba}, \code{udoi}, or \code{hd}.}

\item{conditional}{\verb{[logical](1)} \cr Whether or not conditional UDs are
used. If \code{TRUE} levels from that were used to estimate home ranges will be
used.}

\item{which}{\verb{[character = "consecutive"]} \cr Should only consecutive overlaps be calculated or all combinations?}

\item{labels}{\verb{[character=NULL]} \cr Labels for different instances. If \code{NULL} (the default) numbers will be used.}
}
\value{
\code{data.frame} with the isopleth level and area in units of the
coordinate reference system.
}
\description{
Methods to calculate the overlap of two or more home-range estimates.
}
