% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_ctmm.R
\name{fit_ctmm}
\alias{fit_ctmm}
\title{Fit a continuous time movement model with \code{ctmm}}
\usage{
fit_ctmm(x, model, ...)
}
\arguments{
\item{x}{\code{[track_xyt]} \cr A track created with \code{make_track} that includes time.}

\item{model}{\verb{[character(1)="bm"]\{"iid", "bm","ou","ouf", "auto"\}} \cr The autocorrelation model that should be fit to the data. \code{iid} corresponds to uncorrelated independent data, \code{bm} to Brownian motion, \code{ou} to an Ornstein-Uhlenbeck process, \code{ouf} to an Ornstein-Uhlenbeck forage process. \code{auto} will use model selection with AICc to find the best model.}

\item{...}{Additional parameters passed to \code{ctmm::ctmm.fit} or \code{ctmm::ctmm.select} for \code{model = "auto"}}
}
\value{
A \code{ctmm} object.
}
\description{
Fit a continuous time movement model with \code{ctmm}
}
\examples{
data(deer)
m1 <- fit_ctmm(deer, "iid")
summary(m1)
}
\references{
C. H. Fleming, J. M. Calabrese, T. Mueller, K.A. Olson, P. Leimgruber, W. F. Fagan, “From fine-scale foraging to home ranges: A semi-variance approach to identifying movement modes across spatiotemporal scales”, The American Naturalist, 183:5, E154-E167 (2014).
}
