% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplex.R
\name{noise_simplex}
\alias{noise_simplex}
\title{Simplex noise generator}
\usage{
noise_simplex(dim, frequency = 0.01, interpolator = "quintic",
  fractal = "fbm", octaves = 3, lacunarity = 2, gain = 0.5,
  pertubation = "none", pertubation_amplitude = 1)
}
\arguments{
\item{dim}{The dimensions (height, width, (and depth, (and time))) of the
noise to be generated. The length determines the dimensionality of the noise.}

\item{frequency}{Determines the granularity of the features in the noise.}

\item{interpolator}{How should values between sampled points be calculated?
Either \code{'linear'}, \code{'hermite'}, or \code{'quintic'} (default), ranging from lowest
to highest quality.}

\item{fractal}{The fractal type to use. Either \code{'none'}, \code{'fbm'} (default),
\code{'billow'}, or \code{'rigid-multi'}. It is suggested that you experiment with the
different types to get a feel for how they behaves.}

\item{octaves}{The number of noise layers used to create the fractal noise.
Ignored if \code{fractal = 'none'}. Defaults to \code{3}.}

\item{lacunarity}{The frequency multiplier between successive noise layers
when building fractal noise. Ignored if \code{fractal = 'none'}. Defaults to \code{2}.}

\item{gain}{The relative strength between successive noise layers when
building fractal noise. Ignored if \code{fractal = 'none'}. Defaults to \code{0.5}.}

\item{pertubation}{The pertubation to use. Either \code{'none'} (default),
\code{'normal'}, or \code{'fractal'}. Defines the displacement (warping) of the noise,
with \code{'normal'} giving a smooth warping and \code{'fractal'} giving a more eratic
warping.}

\item{pertubation_amplitude}{The maximal pertubation distance from the
origin. Ignored if \code{pertubation = 'none'}. Defaults to \code{1}.}
}
\value{
If \code{length(dim) == 2} a matrix, if \code{length(dim) \%in\% c(3, 4)} a 3- or
4-dimensional array.
}
\description{
Simplex noise has been developed by Ken Perlin, the inventor of perlin noise,
in order to address some of the shortcomings he saw in perlin noise. Compared
to perlin noise, simplex noise has lower computational complexity, making it
feasable for dimensions above 3 and has no directional artifacts.
}
\examples{
# Basic use
noise <- noise_simplex(c(100, 100))

image(noise, col = grey.colors(256, 0, 1))

}
\references{
Ken Perlin, (2001) \emph{Noise hardware}. In Real-Time Shading SIGGRAPH Course Notes, Olano M., (Ed.)
}
