% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.rmse}
\alias{intFun.rmse}
\title{Root mean square error (RMSE)}
\usage{
intFun.rmse(mod, ref)
}
\arguments{
\item{mod}{An R object (model output data)}

\item{ref}{An R object (reference data)}
}
\value{
An R object that gives the root mean square error when comparing
\code{mod} against \code{ref}.
}
\description{
This function computes the root mean square error (RMSE), which is defined as:

\eqn{$rmse(\lambda, \phi)=\sqrt{\frac{1}{t_{f}-t_{0}}\int_{t_{0}}^{t_{f}}(v_{mod}(t,\lambda, \phi)-v_{ref}(t,\lambda, \phi))^{2}dt}$}

where \eqn{\lambda} is the longitude, \eqn{\phi} is the latitude, \eqn{t}
is the time, \eqn{t_0} is the initial time step, \eqn{t_f} is the final time
time step, \eqn{v_{mod}} is a modelled variable and \eqn{v_{ref}} is the
corresponding reference variable.
}
\examples{

library(raster)
# create two raster stacks
for(i in 1:100)
{
 mod <- raster::raster(matrix(runif(100,-1,1), ncol=10))
 ref <- raster::raster(matrix(runif(100,-2,2), ncol=10))
 assign(paste('mod', i , sep='_'), mod)
 assign(paste('ref', i , sep='_'), ref)
}
my.list.mod <- lapply(ls(pattern='mod_'), get)
my.list.ref <- lapply(ls(pattern='ref_'), get)
mod <- do.call(stack, my.list.mod)
ref <- do.call(stack, my.list.ref)
# compute RMSE
rmse <- intFun.rmse(mod,ref)
plot(rmse); text(rmse, digits=2)

}
\keyword{internal}
