% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{get_contributors}
\alias{get_contributors}
\title{get_contributors}
\usage{
get_contributors(
  org,
  repo,
  type = c("code", "issues", "discussion"),
  alphabetical = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{org}{Github organisation name for repository}

\item{repo}{Repository within \code{org} for which contributors are to be
extracted}

\item{type}{Type of contributions to include: 'code' for direct code
contributions (including documentation), 'issues' to recognise contributors
who open issues, and 'discussion' for contributing to discussions within
issues. Discussion contributions are only from individuals not present in
either 'issues' or 'code'; and 'issues' contributions are only from
individuals not present in 'code'.}

\item{alphabetical}{If \code{TRUE}, order contributors alphabetically, otherwise
order by decreasing numbers of contributions.}

\item{quiet}{If \code{FALSE}, display progress information on screen.}
}
\description{
Get all contributors to a repository, including those who contribute to code,
open issues, and contribute to discussions in issues.
}
\examples{
\dontrun{
get_contributors (org = "ropenscilabs", repo = "allcontributors")
}
}
