% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alf_session.R
\name{alf_session}
\alias{alf_session}
\title{Get connection session to Alfresco content repository}
\usage{
alf_session(server, username, password)
}
\arguments{
\item{server}{Alfresco server URL}

\item{username}{user name}

\item{password}{password}
}
\value{
Connection session to Alfresco repository
}
\description{
Validates authentication details with Alfresco content repository, returning ticket, server details and endpoints if
successful.
}
\examples{
\donttest{
# establish a connection to the alfresco content repository
my_session <- alf_session("alfresco.my-org.com", "admin", "admin")

# output the server URL
print(my_session$server)
#[1] "alfresco.my-org.com"

# output the connection ticket
print(my_session$ticket)
#[1] "xxx-xxx-xxx-xxx"
}
}
