% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{image}
\alias{image}
\alias{image,TimeSeries-method}
\title{Heat Map}
\usage{
\S4method{image}{TimeSeries}(x, calendar = getOption("aion.calendar"), k = 1, ...)
}
\arguments{
\item{x}{A \code{\linkS4class{TimeSeries}} object.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}).}

\item{k}{An \code{\link{integer}} specifying the slice of \code{x} along the third
dimension to be plotted.}

\item{...}{Further parameters to be passed to \code{\link[graphics:image]{graphics::image()}}.}
}
\value{
\code{image()} is called for its side-effects: it results in a graphic
being displayed. Invisibly returns \code{x}.
}
\description{
Heat Map
}
\examples{
## Create 6 time-series of 50 observations
## Sampled every two years starting from 2000 BP
X <- series(
  object = matrix(rnorm(300), nrow = 50, ncol = 6),
  time = seq(2000, by = -2, length.out = 50),
  calendar = BP()
)

## Image
image(X, calendar = CE())
}
\seealso{
\code{\link[graphics:image]{graphics::image()}}

Other plotting tools: 
\code{\link{plot}()},
\code{\link{year_axis}()}
}
\author{
N. Frerebeau
}
\concept{plotting tools}
