% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{plot_split_crd}
\alias{plot_split_crd}
\title{Plot Split Plot Designs (crd)}
\usage{
plot_split_crd(
  design,
  nrows,
  ncols,
  factor_name_1 = "T1",
  factor_name_2 = "T2",
  labels = "plots",
  subplots = TRUE,
  width = 1,
  height = 1,
  space_width = 0.95,
  space_height = 0.85,
  reverse_y = FALSE,
  reverse_x = FALSE
)
}
\arguments{
\item{design}{outdesign from \code{agricolae} package}

\item{nrows}{Number of rows for the design}

\item{ncols}{Number of columns for the design}

\item{factor_name_1}{string Which factor should be used for plotting, needs to be a column in outdesign$book}

\item{factor_name_2}{string Which factor should be used for plotting, needs to be a column in outdesign$book}

\item{labels}{string Describes the column from that the plots are taken to display them}

\item{subplots}{should the plot function return the subplots (default) or main plots?}

\item{width}{numeric value, describes the width of a plot in an experiment}

\item{height}{numeric value, describes the height of a plot in an experiment}

\item{space_width}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of width}

\item{space_height}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of height}

\item{reverse_y}{boolean, should the plots of the experiment be changed in reverse order in Row direction? use reverse_y=TRUE to have same sketch as in agricolae. default:reverse_y=FALSE}

\item{reverse_x}{boolean, should the plots of the experiment be changed in reverse order in column direction? default:reverse_x=FALSE}
}
\value{
\code{ggplot} graphic that can be modified, if wished
}
\description{
Plot a design of a split plot experiment with a complete randomized design (crd) from design.split
}
\examples{
library(agricolaeplotr)
library(agricolae)
T1<-c('a','b','c','d','e','f','g')
T2<-c('v','w','x','y','zzz')
r <- 4
outdesign2 <- design.split(trt1=T1, trt2=T2, r=r,
serie = 2, seed = 0, kinds = 'Super-Duper',
randomization=TRUE,first=TRUE,design = 'crd')
plot_split_crd(outdesign2,ncols = 6,nrows=5)

outdesign2 <- design.split(trt1=T1, trt2=T2, r=r,
serie = 2, seed = 0, kinds = 'Super-Duper',
randomization=FALSE,first=TRUE,design = 'crd')
plot_split_crd(outdesign2,ncols = 6,nrows=5)
}
