% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDistribution.R
\docType{class}
\name{ANOVA-class}
\alias{ANOVA-class}
\alias{ANOVA}
\alias{get_tau_ANOVA}
\title{Analysis of Variance}
\usage{
ANOVA(n_groups)

get_tau_ANOVA(means, common_sd = 1)
}
\arguments{
\item{n_groups}{number of groups to be compared}

\item{means}{vector denoting the mean per group}

\item{common_sd}{standard deviation of the groups}
}
\description{
ANOVA is used to test whether there is a significant difference between the means of groups.
The sample size which \code{adoptr} returns is the group wise sample size.
The function \code{get_tau_ANOVA} is used to obtain a parameter \eqn{\tau},
which is used in the same way as \eqn{\theta} to describe the difference of
means between the groups.
}
\examples{
model <- ANOVA(3L)

H1 <- PointMassPrior(get_tau_ANOVA(c(0.4, 0.8, 0.5)), 1)

}
\seealso{
see \code{\link{probability_density_function}} and
\code{\link{cumulative_distribution_function}} to evaluate the pdf
and the cdf, respectively. Use \code{\link{NestedModels}} to get insights
in the implementation of \code{ANOVA}.
}
