% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaximumSampleSize.R
\docType{class}
\name{MaximumSampleSize-class}
\alias{MaximumSampleSize-class}
\alias{MaximumSampleSize}
\alias{evaluate,MaximumSampleSize,TwoStageDesign-method}
\title{Maximum Sample Size of a Design}
\usage{
MaximumSampleSize(label = "max(n(x1))")

\S4method{evaluate}{MaximumSampleSize,TwoStageDesign}(s, design, optimization = FALSE, ...)
}
\arguments{
\item{label}{object label (string)}

\item{s}{\code{\link[=Scores]{Score}} object}

\item{design}{object}

\item{optimization}{logical, if \code{TRUE} uses a relaxation to real
parameters of the underlying design; used for smooth optimization.}

\item{...}{further optional arguments}
}
\description{
This score evaluates \code{max(n(d))} for a design \code{d}.
}
\examples{
design <- TwoStageDesign(50, .0, 2.0, 50, 2.0, order = 5L)
mss    <- MaximumSampleSize()
evaluate(mss, design)

}
\seealso{
\link{Scores} for general scores and \link{ConditionalSampleSize}
 for evaluating the sample size point-wise.
}
