% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_validate.R
\name{seg_val}
\alias{seg_val}
\title{Validate a segment}
\usage{
seg_val(
  segment_body = NULL,
  rsid = Sys.getenv("AW_REPORTSUITE_ID"),
  debug = FALSE,
  company_id = Sys.getenv("AW_COMPANY_ID")
)
}
\arguments{
\item{segment_body}{The json string of the segment that is being validated (required)}

\item{rsid}{Adobe report suite ID (RSID).  If an environment variable called \code{AW_REPORTSUITE_ID} exists
in \code{.Renviron} or elsewhere and no \code{rsid} argument is provided, then the \code{AW_REPORTSUITE_ID} value will
be used. Use \code{\link[=aw_get_reportsuites]{aw_get_reportsuites()}} to get a list of available \code{rsid} values.}

\item{debug}{This enables the api call information to show in the console for help with debugging issues. default is FALSE}

\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID} exists in \code{.Renviron} or
elsewhere and no \code{company_id} argument is provided, then the \code{AW_COMPANY_ID} value will be used.
Use \code{\link[=get_me]{get_me()}} to get a list of available \code{company_id} values.}
}
\value{
If the segment is valid a message saying the segment validates is returned.
If the segment doesn't validate the errors are returned in a data frame.
}
\description{
Returns a segment validation response for a segment contained in a json string object.
}
