% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_trial.R
\name{validate_trial}
\alias{validate_trial}
\title{Validate trial specification}
\usage{
validate_trial(
  arms,
  true_ys,
  start_probs = NULL,
  fixed_probs = NULL,
  min_probs = rep(NA, length(arms)),
  max_probs = rep(NA, length(arms)),
  data_looks = NULL,
  max_n = NULL,
  look_after_every = NULL,
  control = NULL,
  control_prob_fixed = NULL,
  inferiority = 0.01,
  superiority = 0.99,
  equivalence_prob = NULL,
  equivalence_diff = NULL,
  equivalence_only_first = NULL,
  futility_prob = NULL,
  futility_diff = NULL,
  futility_only_first = NULL,
  highest_is_best = FALSE,
  soften_power = 1,
  cri_width = 0.95,
  n_draws = 5000,
  robust = FALSE,
  description = NULL,
  add_info = NULL,
  fun_y_gen,
  fun_draws,
  fun_raw_est
)
}
\arguments{
\item{arms}{character vector with unique names for the trial arms.}

\item{true_ys}{numeric vector specifying true outcomes (e.g., event
probabilities, mean values, etc.) for all trial \code{arms}.}

\item{start_probs}{numeric vector, allocation probabilities for each arm at
the beginning of the trial. The default (\code{NULL}) is automatically
changed to equal randomisation.}

\item{fixed_probs}{numeric vector, fixed allocation probabilities for each
arm - must be either a numeric vector with \code{NA} for arms without fixed
probabilities and values between \code{0} and \code{1} for the other arms or \code{NULL}
(default), if adaptive randomisation is used for all arms or if one of the
special settings (\code{"sqrt-based"}, \code{"sqrt-based start"},
\code{"sqrt-based fixed"}, or \code{"match"}) is specified for \code{control_prob_fixed}
(described below).}

\item{min_probs}{numeric vector, lower threshold for adaptive allocation
probabilities, lower probabilities will be rounded up to these values. Must
be \code{NA} (default for all arms) if no boundary is wanted.}

\item{max_probs}{numeric vector, upper threshold for adaptive allocation
probabilities, higher probabilities will be rounded down to these values.
Must be \code{NA} (default for all arms) if no boundary is wanted.}

\item{data_looks}{vector of increasing integers, specifies when to conduct
adaptive analyses (= the total number of patients randomised at each
adaptive analysis). The last number in the vector represents the maximum
sample size. Instead of specifying \code{data_looks}, the \code{max_n} and
\code{look_after_every} arguments can be used in combination (then \code{data_looks}
must be \code{NULL}, the default).}

\item{max_n}{single integer, maximum total sample size (defaults to \code{NULL}).
Must only be specified if \code{data_looks} is \code{NULL}. Requires specification of
the \code{look_after_every} argument.}

\item{look_after_every}{single integer, specified together with \code{max_n}.
Adaptive analyses will be conducted after every \code{look_after_every}
patients randomised, and at the total sample size as specified by \code{max_n}
(\code{max_n} does not need to be a multiple of \code{look_after_every}). If
specified, \code{data_looks} must be \code{NULL} (as default).}

\item{control}{single character string, name of one of the \code{arms} or \code{NULL}
(default). If specified, this arm will serve as a common control arm, to
which all other arms will be compared and the
inferiority/superiority/equivalence thresholds (see below) will be for
those comparisons. See \code{\link[=setup_trial]{setup_trial()}} \strong{Details} below for information on
behaviour with respect to these comparisons.}

\item{control_prob_fixed}{if a common \code{control} arm is specified, this must
be set to either \code{NULL} (the default), in which case the control arm
allocation probability will not be fixed if control arms change (the
allocation probability to the first control arm may still be fixed using
\code{fixed_probs}) Otherwise a vector of probabilities of either length \code{1} or
\verb{number of arms - 1} can be provided, or one of the special arguments
\code{"sqrt-based"}, \code{"sqrt-based start"}, \code{"sqrt-based fixed"} or \code{"match"}.
See \code{\link[=setup_trial]{setup_trial()}} \strong{Details} below for details in behaviour.}

\item{inferiority}{single numeric (\verb{> 0} and \verb{<1}, default is \code{0.01})
specifying the inferiority threshold. An arm will be considered inferior
and dropped if the probability that it is best (when comparing all arms) or
better than the control arm (when a common \code{control} is used) drops below
this threshold.}

\item{superiority}{single numeric (\verb{>0} and \verb{<1}, default is \code{0.99})
specifying the superiority threshold. If the probability that an arm is
best (when comparing all arms) or better than the control arm (when a
common \code{control} is used) exceeds this number, said arm will be declared
the winner and the trial will be stopped (if no common \code{control} is used or
if the last comparator is dropped in a design with a common control) \emph{or}
become the new control and the trial will continue (if a common control is
specified).}

\item{equivalence_prob}{single numeric (\verb{> 0} and \verb{< 1}) or \code{NULL} (default,
corresponding to no equivalence assessment). If a numeric value is
specified, arms will be stopped for equivalence if the probability of
either \emph{(a)} equivalence compared to a common \code{control} or \emph{(b)}
equivalence between all arms remaining (designs without a common control)
exceeds this threshold. Requires specification of \code{equivalence_diff},
\code{equivalence_only_first}, and a common \code{control} arm.}

\item{equivalence_diff}{single numeric value (\verb{> 0}) or \code{NULL} (default,
corresponding to no equivalence assessment). If a numeric value is
specified, estimated differences below this threshold will be considered
equivalent when assessing equivalence. For designs with a common \code{control}
arm, the differences between each non-control arm and the \code{control} arm is
used, and for trials without a common \code{control} arm, the difference between
the highest and lowest estimated outcome rates are used and the trial is
only stopped for equivalence if all remaining arms are thus equivalent.}

\item{equivalence_only_first}{single logical in trial specifications where
\code{equivalence_prob} and \code{equivalence_diff} are specified, otherwise \code{NULL}
(default). Must be \code{NULL} for designs without a common control arm. If a
common \code{control} arm is used, this specifies whether equivalence will only
be assessed for the first control (if \code{TRUE}) or also for subsequent
control arms (if \code{FALSE}) if one arm is superior to the first control and
becomes the new control.}

\item{futility_prob}{single numeric (\verb{> 0} and \verb{< 1}) or \code{NULL} (default,
corresponds to no futility assessment). If a numeric value is specified,
\code{arms} will be stopped for futility when the probability for futility
compared to the common \code{control} exceeds this threshold. Requires a common
\code{control} arm, specification of \code{futility_diff} and \code{futility_only_first}.}

\item{futility_diff}{single numeric value (\verb{> 0}) or \code{NULL} (default,
corresponding to no futility assessment). If a numeric value is specified,
estimated differences below this threshold in the \emph{beneficial} direction
(as specified in \code{highest_is_best}) will be considered futile when
assessing futility in designs with a common \code{control} arm. If only 1 arm
remains after dropping arms for futility, the trial will be stopped without
declaring the last arm superior.}

\item{futility_only_first}{single logical in trial specifications designs
where \code{futility_prob} and \code{futility_diff} are specified, otherwise \verb{NULL (default). Must be }NULL\verb{for designs without a common}control\verb{arm. Specifies whether futility will only be assessed against the first}control\verb{(if}TRUE\verb{) or also for subsequent control arms (if }FALSE`) if
one arm is superior to the first control and becomes the new control.}

\item{highest_is_best}{single logical, specifies whether larger estimates of
the outcome are favourable or not; defaults to \code{FALSE}, corresponding to,
e.g., an undesirable binary outcomes (e.g., mortality) or a continuous
outcome where lower numbers are preferred (e.g., hospital length of stay).}

\item{soften_power}{either a single numeric value or a numeric vector of
exactly the same length as the maximum number of looks/adaptive analyses.
Values must be between \code{0} and \code{1} (default); if \verb{< 1}, then re-allocated
non-fixed allocation probabilities are all raised to this power to make
allocation probabilities less extreme, in turn used to redistribute
remaining probability while respecting limits when defined by \code{min_probs}
and/or \code{max_probs}. If \code{1}, then no \emph{softening} is applied.}

\item{cri_width}{single numeric \verb{>= 0} and \verb{< 1}, the width of the
percentile-based credible intervals used when summarising individual trial
results. Defaults to \code{0.95}, corresponding to 95\% credible intervals.}

\item{n_draws}{single integer, the number of draws from the posterior
distributions (for each arm) used when running the trial. Defaults to
\code{5000}; can be reduced for a speed gain (at the potential loss of stability
of results if too low) or increased for increased precision (takes longer).
Values \verb{< 100} are not allowed and values \verb{< 1000} are not recommended
and warned against.}

\item{robust}{single logical, if \code{TRUE} (default) the medians and median
absolute deviations (scaled to be comparable to the standard deviation for
normal distributions; MAD_SD) are used to summarise the posterior
distributions; if \code{FALSE}, the means and standard deviations (SDs) are used
instead (slightly faster, but may be less appropriate for posteriors skewed
on the natural scale).}

\item{description}{optional single character string describing the trial
design, will only be used in print functions if not \code{NULL} (the default).}

\item{add_info}{optional single string containing additional information
regarding the trial design or specifications, will only be used in print
functions if not \code{NULL} (the default).}

\item{fun_y_gen}{function, generates outcomes. See \code{\link[=setup_trial]{setup_trial()}}
\strong{Details}
for information on how to specify this function.\cr
\strong{Note:} this function is called once during setup to validate the output
structure.}

\item{fun_draws}{function, generates posterior draws. See \code{\link[=setup_trial]{setup_trial()}}
\strong{Details} for information on how to specify this function.\cr
\strong{Note:} this function is called up to three times during setup to
validate the output structure.}

\item{fun_raw_est}{function that takes a numeric vector and returns a
single numeric value, used to calculate a raw summary estimate of the
outcomes in each \code{arm}. Defaults to \code{\link[=mean]{mean()}}, which is always used in the
\code{\link[=setup_trial_binom]{setup_trial_binom()}} and \code{\link[=setup_trial_norm]{setup_trial_norm()}} functions.\cr
\strong{Note:} the function is called one time per arm during setup to validate
the output structure.}
}
\value{
An object of class \code{trial_spec} containing the validated trial
specification.
}
\description{
Used internally. Validates the inputs common to all trial specifications, as
specified in \code{\link[=setup_trial]{setup_trial()}}, \code{\link[=setup_trial_binom]{setup_trial_binom()}} and \code{\link[=setup_trial_norm]{setup_trial_norm()}}.
}
\keyword{internal}
