% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_trials.R
\name{prog_breaks}
\alias{prog_breaks}
\title{Generate breakpoints and other values for printing progress}
\usage{
prog_breaks(progress, n_rep_new, cores)
}
\arguments{
\item{progress}{single numeric \verb{> 0} and \verb{<= 1} or \code{NULL}. If \code{NULL}
(default), no progress is printed to the console. Otherwise, progress
messages are printed to the control at intervals proportional to the value
specified by progress.\cr
\strong{Note:} as printing is not possible from within clusters on multiple
cores, the function conducts batches of simulations on multiple cores (if
specified), with intermittent printing of statuses. Thus, all cores have to
finish running their current assigned batches before the other cores may
proceed with the next batch. If there is substantial differences in the
simulation speeds across cores, using \code{progress} may thus increase total
simulation times.}

\item{n_rep_new}{single integers, number of new simulations to run (i.e.,
\code{n_rep} as supplied to \code{\link[=run_trials]{run_trials()}} minus the number of previously run
simulations if \code{grow} is used in \code{\link[=run_trials]{run_trials()}}).}

\item{cores}{single integer; the number of cores to run the simulations on
using the \pkg{parallel} library. Defaults to \code{1}; may be increased to run
multiple simulations in parallel. \code{\link[parallel:detectCores]{parallel::detectCores()}} may be used to
find the number of available cores.}
}
\value{
List containing \code{breaks} (the number of patients at each break),
\code{start_mess} and \code{prog_mess} (the first and subsequent progress messages'
basis), and \code{batches} (a list with each entry corresponding to the
simulation numbers in each batch).
}
\description{
Used internally. Generates breakpoints, messages, and 'batches' of trial
numbers to simulate when using \code{\link[=run_trials]{run_trials()}} with the \code{progress} argument in
use. Breaks will be multiples of the number of \code{cores}, and repeated use of
the same values for breaks is avoided (if, e.g., the number of breaks times
the number of cores is not possible if few new trials are to be run). Inputs
are validated by \code{\link[=run_trials]{run_trials()}}.
}
\keyword{internal}
