% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_funs.R
\name{prob_all_equi}
\alias{prob_all_equi}
\title{Calculate the probability that all arms are practically equivalent}
\usage{
prob_all_equi(m, equivalence_diff = NULL)
}
\arguments{
\item{m}{a matrix with one column per trial arm (named as the \code{arms}) and one
row for each draw from the posterior distributions.}

\item{equivalence_diff}{single numeric value (\verb{> 0}) or \code{NULL} (default,
corresponding to no equivalence assessment). If a numeric value is
specified, estimated differences below this threshold will be considered
equivalent when assessing equivalence. For designs with a common \code{control}
arm, the differences between each non-control arm and the \code{control} arm is
used, and for trials without a common \code{control} arm, the difference between
the highest and lowest estimated outcome rates are used and the trial is
only stopped for equivalence if all remaining arms are thus equivalent.}
}
\value{
A single numeric value corresponding to the probability of all arms
being practically equivalent.
}
\description{
Used internally. This function takes a \code{matrix} as calculated by the
\code{\link[=get_draws_binom]{get_draws_binom()}}, \code{\link[=get_draws_norm]{get_draws_norm()}} or a corresponding custom function
(specified using the \code{fun_draws} argument in \code{\link[=setup_trial]{setup_trial()}}; see
\code{\link[=get_draws_generic]{get_draws_generic()}}), and an equivalence difference, and calculates the
probability of all arms being equivalent (absolute differences between
highest and lowest value in the same set of posterior draws being less than
the difference considered equivalent).
}
\keyword{internal}
