% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summarise_dist}
\alias{summarise_dist}
\title{Summarise distribution}
\usage{
summarise_dist(x, robust = TRUE, interval_width = 0.95)
}
\arguments{
\item{x}{a numeric vector of posterior draws.}

\item{robust}{single logical. if \code{TRUE} (default) the median and median
absolute deviation (MAD-SD; scaled to be comparable to the standard
deviation for normal distributions) are used to summarise the distribution;
if \code{FALSE}, the mean and standard deviation (SD) are used instead (slightly
faster, but may be less appropriate for skewed distribution).}

\item{interval_width}{single numeric value (\verb{> 0} and \verb{<1}); the width of the
interval; default is 0.95, corresponding to 95\% percentile-base credible
intervals for posterior distributions.}
}
\value{
A numeric vector with four named elements: \code{est} (the median/mean),
\code{err} (the MAD-SD/SD), \code{lo} and \code{hi} (the lower and upper boundaries of the
interval).
}
\description{
Used internally, to summarise posterior distributions, but the logic does
apply to any distribution (thus, the name).
}
\details{
MAD-SDs are scaled to correspond to SDs if distributions are normal,
similarly to the \link{mad} function; see details regarding calculation in that
function's description.
}
\keyword{internal}
