% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varianceComponents.R
\name{varianceOnEvecs}
\alias{varianceOnEvecs}
\title{Variance along eigenvectors of Q}
\usage{
varianceOnEvecs(X, Q)
}
\arguments{
\item{X}{An \eqn{n \times p} data matrix, each row corresponding to a sample.}

\item{Q}{A \eqn{p \times p} similarity matrix, either as a matrix
or as its eigendecomposition (the output from \code{eigen}).}
}
\value{
A vector containing the variance of the samples along each
of the eigenvectors of \code{Q}.
}
\description{
Project the sample points stored in the rows of \code{X} along the
eigenvectors of \code{Q} and find the variance along each of the
projections.
}
\examples{
data(AntibioticSmall)
voe = varianceOnEvecs(AntibioticSmall$X, AntibioticSmall$Q)
}
