% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gadgets.R
\name{inspectTaxonomy}
\alias{inspectTaxonomy}
\title{Shiny gadget for tree/taxonomy inspection}
\usage{
inspectTaxonomy(agpcafit, physeq, axes = c(1, 2), br.length = FALSE,
  height = 600)
}
\arguments{
\item{agpcafit}{An agpca object, created either by the function
\code{\link{adaptivegpca}} or by
\code{\link{visualizeFullFamily}}.}

\item{physeq}{A phyloseq object with a tree and a taxonomy table.}

\item{axes}{The axes to plot, must be a vector of two whole
numbers.}

\item{br.length}{Plot the tree with the branch lengths?}

\item{height}{The height, in pixels, of the plotting region.}
}
\value{
The function will open a browser window showing the tree
    and the locations of the taxa on the selected agpca
    axes. "Brushing" over the plot will highlight the positions of
    the selected taxa on the tree and list their taxonomic
    assignments. Clicking the "done" button will exit the app and
    return a data frame containing the positions of the selected
    taxa on the agpca axes, the taxonomic assignments of the
    selected taxa, and their names.
}
\description{
Shiny gadget that allows users to visualize the scores of the taxa
on the agpca axes, their positions on the phylogenetic tree, and
their taxonomic assignments.
}
\examples{
\dontrun{
data(AntibioticPhyloseq)
pp = processPhyloseq(AntibioticPhyloseq)
out.agpca = adaptivegpca(pp$X, pp$Q, k = 2)
treeInspect(out.agpca, AntibioticPhyloseq)
}
}
