% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aceDiffEditor.R
\name{aceDiffEditor}
\alias{aceDiffEditor}
\title{Ace diff editor}
\usage{
aceDiffEditor(
  file1,
  file2,
  mode = NULL,
  theme = NULL,
  fontSize = 14,
  tabSize = NULL,
  autoCompletion = TRUE,
  snippets = FALSE,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{file1, file2}{paths to files}

\item{mode}{the language of the files; if \code{NULL}, the mode is guessed
from the extension of the first file;
run \code{\link{getAceModes}} to get the list of available modes}

\item{theme}{the theme of the editor; if \code{NULL}, the theme is set to the
theme currently used in RStudio; run \code{\link{getAceThemes}} to get
the list of available themes}

\item{fontSize}{font size}

\item{tabSize}{number of spaces for the indentation (usually \code{2} or
\code{4}); if \code{NULL}, it is set to the one used in RStudio}

\item{autoCompletion}{logical, whether to enable the auto completion}

\item{snippets}{logical, whether to enable the snippets (for example, there
is a snippet for \code{switch} in JavaScript)}

\item{width, height}{dimensions; the default values are nice for usage in
the RStudio viewer pane}

\item{elementId}{a HTML id for the container; this is useless for common
usage}
}
\description{
Open the Ace diff editor.
}
\note{
The diff editor does not correctly reacts when one resizes the RStudio
  viewer pane. You have to resize it before opening the diff editor.
}
\examples{
file <- system.file("htmlwidgets", "aceEditor.css", package = "aceEditor")
aceDiffEditor(file, file)
}
