% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{smoke_test}
\alias{smoke_test}
\title{Test your testing function for common edge cases}
\usage{
smoke_test(dat, test, verbose = FALSE, halt = TRUE)
}
\arguments{
\item{dat}{an example dataset. For example the full dataset
to be fed into \code{\link{accumulate}} or \code{\link{cumulate}}.}

\item{test}{A testing function to be passed as argument to \code{\link{accumulate}}
or \code{\link{cumulate}}.}

\item{verbose}{\code{[logical]} If \code{TRUE}, all results (including
passed tests) are printed.  If \code{FALSE} only failed tests are printed.}

\item{halt}{\code{[logical]} toggle stopping when an error is thrown}
}
\value{
\code{NULL}, invisibly. This function has as side-effect that test
results are printed to screen.
}
\description{
Writing a testing function that works on any subset of records of a
dataframe can be quite subtle. This function tries the testing function on a
number of common (edge) cases that are easily overlooked.  It is \emph{not}
a unit test: a smoke test will not tell you whether your output is correct.
It only checks the output data type (mustbe \code{TRUE} or \code{FALSE} and
reports if errors, warnings, or messages occur.
}
\examples{
dat <- data.frame(x = 1:5, y=(-2):2)
smoke_test(dat, function(d) y > 0)   #error: Y not found
smoke_test(dat, function(d) d$y > 0) # issue: output too long, not robust against NA
smoke_test(dat, function(d) sum(d$y > 0) > 2) # issue: not robust against NA
smoke_test(dat, function(d) sum(d$y > 0, na.rm=TRUE) > 2) # OK

}
