% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.accrual_df}
\alias{print.accrual_df}
\alias{print.accrual_list}
\title{Print methods for accrual objects}
\usage{
\method{print}{accrual_df}(x, head = TRUE, ...)

\method{print}{accrual_list}(x, ...)
}
\arguments{
\item{x}{object of class 'accrual_df' or 'accrual_list' produced by accrual_create_df.}

\item{head}{show header of the accrual data?}

\item{...}{arguments passed to head}
}
\value{
No return value
}
\description{
Print methods for accrual objects
}
\examples{
set.seed(2020)
enrollment_dates <- as.Date("2018-01-01") + sort(sample(1:30, 50, replace=TRUE))
accrual_df<-accrual_create_df(enrollment_dates)
print(accrual_df)
# only show text
print(accrual_df, head = FALSE)
# show first 15 days
print(accrual_df, n = 15)
}
