% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decay_binary.R
\name{decay_binary}
\alias{decay_binary}
\title{Binary (aka step) decay function}
\usage{
decay_binary(cutoff)
}
\arguments{
\item{cutoff}{A \code{numeric} value. A number indicating the max cutoff point of
travel cost.}
}
\value{
A \code{function} that converts travel time cost t_id into an impedance factor.
}
\description{
Returns a step a number of impedance function to be used inside \code{accessibility}
functions.
}
\examples{
library(accessibility)

# Create a binary impedance function
impedance <- decay_binary(cutoff = 30)

impedance(t_ij = 20)

impedance(t_ij = 35)

}
\seealso{
Other Impedance functions: 
\code{\link{decay_exponential}()},
\code{\link{decay_linear}()},
\code{\link{decay_power}()}
}
\concept{Impedance functions}
