% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SZVD_kFold_cv.R
\name{SZVD_kFold_cv}
\alias{SZVD_kFold_cv}
\alias{SZVD_kFold_cv.default}
\title{Cross-validation of sparse zero variance discriminant analysis}
\usage{
SZVD_kFold_cv(X, ...)

\method{SZVD_kFold_cv}{default}(X, Y, folds, gams, beta, D, q, maxits, tol,
  ztol, feat, penalty, quiet)
}
\arguments{
\item{X}{n by p data matrix, variables should be scaled to by sd}

\item{...}{Parameters passed to SZVD.default.}

\item{Y}{n by K indicator matrix.}

\item{folds}{number of folds to use in K-fold cross-validation.}

\item{gams}{Number of regularly spaced regularization parameters to try in [0,1]*max_gamma.
See details for how max_gamma is computed in the function.}

\item{beta}{Augmented Lagrangian parameter. Must be greater than zero.}

\item{D}{Penalty dictionary basis matrix.}

\item{q}{Desired number of discriminant vectors.}

\item{maxits}{Number of iterations to run ADMM algorithm.}

\item{tol}{Stopping tolerances for ADMM, must have tol$rel and tol$abs.}

\item{ztol}{Rounding tolerance for truncating entries to 0.}

\item{feat}{Maximum fraction of nonzero features desired in validation scheme.}

\item{penalty}{Controls whether to apply reweighting of l1-penalty (using sigma = within-class std devs)}

\item{quiet}{toggles between displaying intermediate statistics.}
}
\value{
\code{SZVDcv} returns an object of \code{\link{class}} "\code{SZVDcv}"
       including a list with the named components \code{DVs} and \code{gambest}.
       Where \code{DVs} are the discriminant vectors for the best l1 regularization
       parameter and \code{gambest} is the best regularization parameter found
       in the cross-validation.

\code{NULL}
}
\description{
Applies alternating direction methods of multipliers to solve sparse
zero variance discriminant analysis.
}
\details{
Add how max_gamma is calculated from the ZVD solution.
This function might require a wrapper similar to ASDA.
}
\examples{
  P <- 150 # Number of variables
  N <- 20 # Number of samples per class

  # Mean for classes, they are zero everywhere except the first 3 coordinates
  m1 <- rep(0,P)
  m1[1] <- 3

  m2 <- rep(0,P)
  m2[2] <- 3

  m3 <- rep(0,P)
  m3[3] <- 3

  # Sample dummy data
  Xtrain <- rbind(MASS::mvrnorm(n=N,mu = m1, Sigma = diag(P)),
                 MASS::mvrnorm(n=N,mu = m2, Sigma = diag(P)),
                MASS::mvrnorm(n=N,mu = m3, Sigma = diag(P)))


  # Generate the labels
  Ytrain <- cbind(c(rep(1,N),rep(0,2*N)),
                  c(rep(0,N),rep(1,N),rep(0,N)),
                  c(rep(0,2*N),rep(1,N)))

  # Normalize the data
  Xt <- accSDA::normalize(Xtrain)
  Xtrain <- Xt$Xc

  # Train the classifier and increase the sparsity parameter from the default
  # so we penalize more for non-sparse solutions.
  res <- accSDA::SZVD_kFold_cv(Xtrain,Ytrain,folds=2,gams=2,beta=2.5,q=1, D=diag(P),
                              maxits=50,tol=list(abs=1e-2,rel=1e-2),
                              ztol=1e-3,feat=0.3,quiet=FALSE,penalty=TRUE)
}
\seealso{
Used by: \code{\link{SZVDcv}}.
}
