% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_cnj.R
\name{sample_cnj}
\alias{sample_cnj}
\title{Generate sample Brazilian lawsuit identification numbers}
\usage{
sample_cnj(
  n,
  foros,
  anos,
  orgao,
  tr,
  first_dig = "0",
  sample_pars = TRUE,
  return_df = TRUE
)
}
\arguments{
\item{n}{A non negative integer giving the number of codes to generate}

\item{foros}{One or more strings with 4 characters indicating the juridical
forum for the sampled codes}

\item{anos}{One or more strings with 4 characters indicating the distribution
years of the generated codes}

\item{orgao}{One or more strings with 1 character indicating the jurisdiction
of the sampled codes.}

\item{tr}{One or more strings with 1 character indicating the court of the
generated codes}

\item{first_dig}{The first digit of the lawsuit code (\code{"0"} by default and
sampled if \code{""})}

\item{sample_pars}{Whether or not the parameters define the characteristics
of the codes}

\item{return_df}{Whether or not the function should return a data frame}
}
\value{
A data frame or a vector containing a random sample of lawsuits IDs
}
\description{
Returns a data frame containing a random sample of lawsuit
numbers distributed according to some regional and jurisdictional parameters.
The implementation supports both vector and scalar parameters, depending
whether or not the function should uniformly sample from a scope of lawsuit
numbers or one should define the parameters for each sample unit.
}
\examples{
{
  # sampling the parameters
  sample_cnj(3,
    foros = "0000",
    anos = "2015", orgao = 8, tr = 26,
    first_dig = "0", sample_pars = TRUE, return_df = FALSE
  )

  sample_cnj(10,
    foros = c("0000", "0001"),
    anos = c("2014", "2015"), orgao = 8, tr = 26,
    first_dig = "0", sample_pars = TRUE, return_df = FALSE
  )

  # not sampling the parameters

  sample_cnj(3,
    foros = c("0000", "0001", "0002"),
    anos = c("2014", "2015", "2016"), orgao = rep(8, 3), tr = rep(26, 3),
    first_dig = "0", sample_pars = FALSE, return_df = FALSE
  )
}
}
