% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_cnj.R
\name{sample_cnj}
\alias{sample_cnj}
\title{Sample brazilian lawsuits identification number}
\usage{
sample_cnj(n, foros, anos, orgao, tr, first_dig = "0", sample_pars = T,
  return_df = T)
}
\arguments{
\item{n}{a non negative integer giving the number of process codes to sample.}

\item{foros}{a string scalar (or vector) with 4 characters. Identifies the 
juridical forum for the sampled codes.}

\item{anos}{a string scalar (or vector) with 4 characters. Identifies the 
distribution years of the sampled codes.}

\item{orgao}{a string scalar (or vector) with 1 character. Identifies the 
jurisdiction of the sampled codes.}

\item{tr}{a string scalar (or vector) with 2 characters. Identifies the court
of the sampled codes.}

\item{first_dig}{the first digit of the process code. It's usually "0" or 
"1". "0" as detault. The first digit will be sampled if first_dig = "".}

\item{sample_pars}{a logical scalar. Does the parameters define the 
characteristics of the codes or should be sampled as well?}

\item{return_df}{Logical scalar. Should the function return a df? If FALSE 
the function returns a vector.}
}
\value{
A data_frame or a vector contaning a random sample of lawsuits ID's.
}
\description{
\code{sample_cnj} returns a data_frame containing a random sample of docket 
numbers distributed according to some regional and jurisdictional parameters.
The implementation supports both vector and scalar parameters, depending 
whether or not the function should uniformly sample from a scope of docket
numbers or one should define the parameters for each sample unit.
}
\examples{

#sampling the parameters
sample_cnj(3, foros = "0000",
anos = "2015", orgao = 8, tr = 26,
first_dig = "0",sample_pars = TRUE, return_df = FALSE)

sample_cnj(10, foros = c("0000","0001"),
anos = c("2014","2015"), orgao = 8, tr = 26,
first_dig = "0",sample_pars = TRUE, return_df = FALSE)

#not sampling the parameters

sample_cnj(3, foros = c("0000","0001","0002"),
anos = c("2014","2015","2016"), orgao = rep(8,3), tr = rep(26,3),
first_dig = "0",sample_pars = FALSE, return_df = FALSE)

}

