% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{vt.subgroups}
\alias{vt.subgroups}
\title{Visualize subgroups}
\usage{
vt.subgroups(vt.trees, only.leaf = T, only.fav = T, tables = F,
  verbose = F, compete = F)
}
\arguments{
\item{vt.trees}{\code{\link{VT.tree}} object. Or return of 
\code{\link{vt.tree}} function. Can be a list.}

\item{only.leaf}{logical to select only leaf of trees. TRUE is default.}

\item{only.fav}{logical select only favorable subgroups (meaning with 
favorable label of the tree). TRUE is default.}

\item{tables}{set to TRUE if tables of incidence must be shown. FALSE is 
default.}

\item{verbose}{print infos during computation. FALSE is default.}

\item{compete}{print competitors rules thanks to competitors computation of
the tree}
}
\value{
data.frame of rules
}
\description{
Function which uses \code{\link{VT.tree}} intern functions. Package 
rpart.plot must be loaded. See \code{\link{VT.tree}} for details.
}
\examples{
\dontrun{
 # data(sepsis)
 vt.o <- vt.data(sepsis, "survival", "THERAPY", T)
 # inside model :
 vt.f <- vt.forest("one", vt.o)
 # use classification tree
 vt.tr <- vt.tree("class", vt.f, threshold = c(0.01, 0.05))
 # show subgroups
 vt.subgroups(vt.tr)
 # change options you'll be surprised !
 vt.subgroups(vt.tr, verbose = T, tables = T) 
}

}

