% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Winters}
\alias{Winters}
\title{Winters Three-parameter Smoothing}
\usage{
Winters(x, period = NULL, trend = 2, lead = 0, plot = TRUE,
  seasonal = c("additive", "multiplicative"), damped = FALSE, alpha = 0.2,
  beta = 0.1057, gamma = 0.07168, phi = 0.98, a.start = NA,
  b.start = NA, c.start = NA)
}
\arguments{
\item{x}{a univariate time series.}

\item{period}{seasonal period. The default is \code{NULL}.}

\item{trend}{the type of trend component, can be one of 1,2,3 which represents constant,
linear and quadratic trend, respectively. The default is \code{trend = 2}.}

\item{lead}{the number of steps ahead for which prediction is required.
The default is \code{0}.}

\item{plot}{a logical value indicating to display the smoothed graph. The default is
\code{TRUE}.}

\item{seasonal}{character string to select an "\code{additive}" or "\code{multiplicative}"
seasonal model. The default is "\code{additive}".}

\item{damped}{a logical value indicating to include the damped trend, only valid for
\code{trend = 2}. The default is \code{FALSE}.}

\item{alpha}{the parameter of level smoothing. The default is \code{0.2}.}

\item{beta}{the parameter of trend smoothing. The default is \code{0.1057}.}

\item{gamma}{the parameter of season smoothing. The default is \code{0.07168}.}

\item{phi}{the parameter of damped trend smoothing, only valid for \code{damped = TRUE}.
The default is \code{0.98}.}

\item{a.start}{the starting value for level smoothing. The default is \code{NA}.}

\item{b.start}{the starting value for trend smoothing. The default is \code{NA}.}

\item{c.start}{the starting value for season smoothing. The default is \code{NA}.}
}
\value{
A list with class "\code{Winters}" containing the following components:
\item{season}{the seasonal factors.}
\item{estimate}{the smoothed values.}
\item{pred}{the prediction, only available with \code{lead} > 0.}
\item{accurate}{the accurate measurements.}
}
\description{
Performs Winters three-parameter smoothing for a univariate time series
with seasonal pattern.
}
\details{
The Winters filter is used to decompose the trend and seasonal components by
updating equations. This is similar to the function \code{\link{HoltWinters}} in
\code{stats} package but may be in different perspective. To be precise, it uses the
updating equations similar to exponential
smoothing to fit the parameters for the following models when
\code{seasonal = "additive"}.
If the trend is constant (\code{trend = 1}):
\deqn{x[t] = a[t] + s[t] + e[t].}
If the trend is linear (\code{trend = 2}):
\deqn{x[t] = (a[t] + b[t]*t) + s[t] + e[t].}
If the trend is quadratic (\code{trend = 3}):
\deqn{x[t] = (a[t] + b[t]*t + c[t]*t^2) + s[t] + e[t].}
Here \eqn{a[t],b[t],c[t]} are the trend parameters, \eqn{s[t]} is the seasonal
parameter for the
season corresponding to time \eqn{t}.
For the multiplicative season, the models are as follows.
If the trend is constant (\code{trend = 1}):
\deqn{x[t] = a[t] * s[t] + e[t].}
If the trend is linear (\code{trend = 2}):
\deqn{x[t] = (a[t] + b[t]*t) * s[t] + e[t].}
If the trend is quadratic (\code{trend = 3}):
\deqn{x[t] = (a[t] + b[t]*t + c[t]*t^2) * s[t] + e[t].}
When \code{seasonal = "multiplicative"}, the updating equations for each parameter can
be seen in page 606-607 of PROC FORECAST document of SAS. Similarly, for the
additive seasonal model, the 'division' (/) for \eqn{a[t]} and \eqn{s[t]} in page 606-607
is changed to 'minus' (-).

The default starting values for \eqn{a,b,c} are computed by a time-trend regression over
the first cycle of time series. The default starting values for the seasonal factors are
computed from seasonal averages. The default smoothing parameters (weights) \code{alpha,
beta, gamma} are taken from the equation \code{1 - 0.8^{1/trend}} respectively. You can
also use the \code{\link{HoltWinters}} function to get the optimal smoothing parameters
and plug them back in this function.

The prediction equation is \eqn{x[t+h] = (a[t] + b[t]*t)*s[t+h]} for \code{trend = 2} and
\code{seasonal = "additive"}. Similar equations can be derived for the other options. When
the \code{damped = TRUE}, the prediction equation is
\eqn{x[t+h] = (a[t] + (\phi + ... + \phi^(h))*b[t]*t)*s[t+h]}. More details can be
referred to R. J. Hyndman and G. Athanasopoulos (2013).
}
\note{
The sum of seasonal factors is equal to the seasonal period. This restriction is
to ensure the identifiability of seasonality in the models above.
}
\examples{
Winters(co2)

Winters(AirPassengers, seasonal = "multiplicative")
}
\author{
Debin Qiu
}
\references{
P. R. Winters (1960) Forecasting sales by exponentially weighted moving averages,
\emph{Management Science} 6, 324-342.

R. J. Hyndman and G. Athanasopoulos, "Forecasting: principles and practice," 2013.
[Online]. Available: \url{http://otexts.org/fpp/}.
}
\seealso{
\code{\link{HoltWinters}}, \code{\link{Holt}}, \code{\link{expsmooth}}
}

