% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maize.muchow.model.r
\name{mm.FAS.fct}
\alias{mm.FAS.fct}
\title{Senescence function for Muchow et al. (1990) Maize model}
\usage{
mm.FAS.fct(TT, TTE, c1 = 0.00161, c2 = 0.00328)
}
\arguments{
\item{TT}{: Thermal time (degC.day)}

\item{TTE}{: Thermal units from sowing to emergence/leaf growth (degC.day)}

\item{c1}{: coefficient of the statistical relation (default : 0.00161)}

\item{c2}{: coefficient of the statistical relation (default : 0.00328)}
}
\value{
Senesced fraction of total leaf area
}
\description{
Senesced fraction of total leaf area (FAS) increase with thermal units (TU) from emergence
}
\examples{
plot(1:2500,mm.FAS.fct(1:2500,TTE=87))
}
\seealso{
\code{\link{maize.muchow.model}}, \code{\link{mm.A.fct}}, \code{\link{mm.LN.fct}}, \code{\link{maize.multisy}},
\code{\link{mm.HI.fct}},\code{\link{maize.muchow.graph}}
}
