#' Zero-Variance Control Variates
#' 
#' @description 
#' Zero-variance control variates (ZV-CV, Mira et al. (2013) <doi:10.1007/s11222-012-9344-6>) is a post-processing method to reduce the variance of Monte Carlo estimators of expectations using the derivatives of the log target. Once the derivatives are available, the only additional computational effort is in solving a linear regression problem. Recently, this method has been extended to higher dimensions using regularisation (South et al., 2018).
#' This package can be used to easily perform ZV-CV or regularised ZV-CV when a set of samples, derivatives and function evaluations are available. Additional functions for applying ZV-CV to two estimators for the normalising constant of the posterior distribution (also known as the evidence) are also supplied.
#'
#' The main functionality is available through
#'
#' \itemize{
#'      \item \code{\link{zvcv}}: The main function to estimate expectations using (regularised) ZV-CV. This function uses a set of \eqn{N} samples along with the associated derivatives of the log target and evaluations of the function of interest.
#'      \item \code{\link{evidence_CTI}}: A function to estimate the evidence using the controlled thermodynamic integration (CTI) identity, with samples from a set of \eqn{T} power posteriors.
#'      \item \code{\link{evidence_SMC}}: A function to estimate the evidence using ZV-CV on the SMC evidence identity, with samples from a set of \eqn{T} power posteriors.
#'}
#'
#' Some additional helper functions are available. See \code{\link{Expand_Temperatures}} and \code{\link{helper_functions}} for further details.
#'
#' An example of estimation posterior expectations and the evidence from SMC samples is available at \link{VDP}.
#'
#'
#' @references
#' Mira, A., Solgi, R., & Imparato, D. (2013). Zero variance Markov chain Monte Carlo for Bayesian estimators. Statistics and Computing, 23(5), 653-662.
#'
#' South, L. F., Oates, C. J., Mira, A., & Drovandi, C. (2018). Regularised zero variance control variates. \url{https://arxiv.org/abs/1811.05073}
#'
#' @author Leah F. South
#' @name ZVCV_package
"_PACKAGE"
#> [1] "_PACKAGE"