\name{YPmodel}
\alias{YPmodel}
\alias{YPmodel.default}
\alias{plot.YPmodel}
\alias{print.YPmodel}
\alias{summary.YPmodel}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
%%  ~~function to do ... ~~
	A main function of package of model of short-term and long-term hazard ratio for survival data 
}
\description{
The main function to perform parameter estimation and hypothesis testing. The corresponding S4 functions, \code{plot.Y Pmodel} and \code{print.Y Pmodel}, are also included to demonstrate the results.
}
\usage{
YPmodel(...)

\method{YPmodel}{default}(data, startPoint, nm, maxIter1, maxIter2, repNum, ...)
\method{print}{YPmodel}(x, ...)
\method{summary}{YPmodel}(object, ...)
\method{plot}{YPmodel}(x, ...)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{\dots}{ For S4 method only. }
  \item{data}{ A properly qualified filename where text data is to be saved, or a dataframe of input data set with three vectors: the event / censoring time (unite: year), the censoring indicator, and the group membership indicator. See the structure of sample data set \code{\link{gastric}} for instance. }
  \item{startPoint}{ Start point for estimating \eqn{\hat{\beta}}. }  
  \item{nm}{ Parameter for parameter estimation, to define the upper boundary for the absolute value of \eqn{\hat{\beta}}. }
  \item{maxIter1}{ Parameter of out-cycle iteration numbers. }
  \item{maxIter2}{ Parameter of inner-cycle iteration numbers. }
  \item{repNum}{ Number of iterations, to be used in the two lack-of-fit tests.}
  \item{x}{ A dataframe of results from an YPmodel default process. }
  \item{object}{ A dataframe of results from an YPmodel default process, equally to x (different symbol for S4 method only). }
}
\value{
An object of class \code{YPmodel}, basically a list including elements
	\item{Data}{ A dataframe of source data, generated from input data by \code{\link{YPmodel.inputData}}. }
  \item{Estimate}{ A dataframe of estimation results, including 1) estimation of \eqn{\hat{\beta}}, 2) its confidential intervals and 3) the odds function of the control group \eqn{\hat{R}(t,\hat{\beta})}, generated by \code{\link{YPmodel.estimate}}. }
	\item{IntervalBands}{ A dataframe of hazard ratios and related confidential intervals and bands, 
  generated by \code{\link{YPmodel.IntervalBands}}. }
  \item{LackFitTest}{ A dataframe of the two lack-of-fit tests for the semi-parametric model, generated by \code{\link{YPmodel.lackfittest}}. }
	\item{Adlgrk}{ A dataframe of the two lack-of-fit tests, to test the hypothesis of equal distribution function in the two groups, generated by \code{\link{YPmodel.adlgrk}}. }
}
\references{
1) YANG, S. AND PRENTICE, R. L. (2010). Improved Logrank-Type Tests for Survival Data Using Adaptive Weights. Biometrics 66, 30-38.  
2) YANG, S. AND PRENTICE, R. L. (2005). Semiparametric analysis of short-term and long-term hazard ratios with two-sample survival data. Biometrika 92, 1-17.  
3) YANG, S. AND ZHAO, Y. (2012). Checking the Short-Term and Long-Term Hazard Ratio Model for Survival Data. Scandinavian Journal of Statistics.
}
\author{
%%  ~~who you are~~
Junlong Sun and Song Yang
}
\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
\code{\link{YPmodel.estimate}},  
\code{\link{YPmodel.IntervalBands}},  
\code{\link{YPmodel.lackfittest}}, 
\code{\link{YPmodel.adlgrk}}
}
\examples{
library(YPmodel)
data(gastric)
result <- YPmodel(gastric, repNum=100)
summary(result)
plot(result)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{YPmodel}
