% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yppe.R
\name{yppe}
\alias{yppe}
\alias{{yppe}}
\title{Fits the Yang and Prentice model with baseline distribution modelled by the piecewise exponential distribution.}
\usage{
yppe(formula, data, n_int = NULL, rho = NULL, tau = NULL,
  hessian = TRUE, approach = c("mle", "bayes"),
  hyper_parms = list(mu_lambda = 0, sigma_lambda = 4, mu_psi = 0,
  sigma_psi = 4, mu_phi = 0, sigma_phi = 4, mu_beta = 0, sigma_beta = 4),
  ...)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which yppe is called.}

\item{n_int}{number of intervals of the PE distribution. If NULL, default value (square root of n) is used.}

\item{rho}{the time grid of the PE distribution. If NULL, the function timeGrid is used to compute rho.}

\item{tau}{the maximum time of follow-up. If NULL, tau = max(time), where time is the vector of observed survival times.}

\item{hessian}{logical; If TRUE (default), the hessian matrix is returned when approach="mle".}

\item{approach}{approach to be used to fit the model (mle: maximum likelihood; bayes: Bayesian approach).}

\item{hyper_parms}{a list containing the hyper-parameters of the prior distributions (when approach = "bayes"). If not specified, default values are used.}

\item{...}{Arguments passed to either `rstan::optimizing` or `rstan::sampling` .}
}
\value{
yppe returns an object of class "yppe" containing the fitted model.
}
\description{
Fits the Yang and Prentice model with baseline distribution modelled by the piecewise exponential distribution.
}
\examples{
\donttest{
# ML approach:
library(YPPE)
mle <- yppe(Surv(time, status)~arm, data=ipass, approach="mle")
summary(mle)

# Bayesian approach:
bayes <- yppe(Surv(time, status)~arm, data=ipass, approach="bayes")
summary(bayes)
}

}
