% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/Interface.R
\docType{class}
\name{from_Server-class}
\alias{$,from_Server-method}
\alias{from_Server}
\alias{from_Server-class}
\alias{initialize,from_Server-method}
\alias{show,from_Server-method}
\title{A Class to Describe General Server Objects}
\usage{
\S4method{initialize}{from_Server}(.Object, ..., referenceClass = TRUE)

\S4method{$}{from_Server}(x, name)

\S4method{show}{from_Server}(object)
}
\arguments{
\item{.Object,referenceClass}{arguments supplied automatically.}

\item{...}{possible slots for subclasses}

\item{x,name}{the object and the field name}

\item{object}{an object from some server class, converted by the \code{$Get()} method
or an equivalent computation, such as supplying \code{.get = TRUE} to a proxy function
call.}
}
\description{
Classes that inherit from this class are used to convert to R a server language
object that is composed of named fields.  The corresponding R object will have
conversions for the fields that can be accessed with the "$" operator.
}
\section{Methods (by generic)}{
\itemize{
\item \code{initialize}: performs some checks on the fields

\item \code{$}: extract a field.  The name must match a field in the
data part.

\item \code{show}: automatic printing, currently just a list of field names.
}}
\section{Slots}{

\describe{
\item{\code{serverClass}}{the name of the server language class}

\item{\code{module}}{the name of the server language module}

\item{\code{language}}{the name of the server language}

\item{\code{fields}}{the names of the server language fields}

\item{\code{data}}{the converted data for the server fields}
}}

