% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProxyClass.R
\name{setProxyClass}
\alias{setProxyClass}
\title{Create a Proxy Class}
\usage{
setProxyClass(Class, module = "", fields = character(), methods = NULL,
  ServerClass = Class, where = topenv(parent.frame()),
  contains = character(), evaluatorClass,
  proxyObjectClass = "ProxyClassObject", language = if (is.null(evaluator))
  "" else evaluator$languageName, readOnly = NULL, ..., save = FALSE,
  objName = Class, docText = NULL)
}
\arguments{
\item{Class}{the name of the class to be used in the proxy, usually just the server language class.}

\item{module}{the name of the server langauge module if it needs to be imported.}

\item{fields, methods}{explicit field and method information if this cannot be found by inspection. Normally omitted.}

\item{ServerClass}{the name of the server language class, normall defaults to \code{Class}.}

\item{where}{the environment for the class definition.  By default, and nearly always, the namespace of the
package in which the call to \code{setProxyClass()} occurs.}

\item{contains}{explicitly needed superclasses if any.}

\item{evaluatorClass}{the evaluator class to identify the evaluator, e.g.  \code{"PythonInterface"} for Python.
By default, the current evaluator class.}

\item{proxyObjectClass}{The general class for proxy objects in this interface.  Typically
obtained automatically from the \code{prototypObject} field of the evaluator.}

\item{language}{the server language, taken from the evaluator if one is found.}

\item{readOnly}{character vector of any field names that should be marked read-only.}

\item{...}{extra arguments to pass on to \code{setRefClass()}.}

\item{save}{If the proxy class is being defined in an application package,
use this to write to a source file (see Ch. 12 of Extending R)
  Default \code{FALSE}, if the proxy class is being assigned in the installation or load of a package.}

\item{objName}{When using the \code{save=} argument to write R code, use this name in the
assignment expression for the generator object.  By default, the name of the class.}

\item{docText}{metadata information supplied by the interface for a particular
server language.}
}
\value{
a generator object for the R class, along with the side effect of setting the class definition.
}
\description{
Creates a proxy class of a given name and other requirements.
Usually infers fields and methods from server language metadata, but can also
use explicitly supplied values.  Particular interface packages will typically have
a specialized version that calls this function.
}
\details{
A proxy class has fields and methods that are created to use the corresponding fields
and methods of the server language, through an interface evaluator.  This function
normally expects information about the class to be returned by the \code{$ServerClassDef()}
method of the evaluator, specialized to the language. It can also be called with explicit
lists for the fields and methods.  The actual fields and methods will use the interface to
access or call the corresponding code in the server language.
}
\references{
Chambers, John M. (2016)
\emph{Extending R},
Chapman & Hall/CRC.
( Chapter 13, discussing this package, is included in the package: \url{../doc/Chapter_XR.pdf}.)
}
